//
//  ASMAllUsersDefaults.h
//
//  Created by Ken Sillart on 7/31/08.
//  Copyright 2008 MYOB Technology Pty. Ltd.. All rights reserved.
//

#pragma once

#import <Cocoa/Cocoa.h>

@interface ASMAllUsersDefaults : NSObject
{
@private
	NSString* bundleIdentifier;
}

+ (ASMAllUsersDefaults *)standardUserDefaults;
+ (ASMAllUsersDefaults *)userDefaultsForApplications:(NSString*)bundleId;

- (instancetype)init;
- (instancetype)initWithBundleIdentifier:(NSString*)bundleId NS_DESIGNATED_INITIALIZER;

- (id)valueForKey:(NSString *)defaultName;
- (void)setValue:(id)value forKey:(NSString *)defaultName;
- (id)objectForKey:(NSString *)defaultName;
- (void)setObject:(id)value forKey:(NSString *)defaultName;
- (void)removeObjectForKey:(NSString *)defaultName;

- (NSString *)stringForKey:(NSString *)defaultName;
- (NSArray *)arrayForKey:(NSString *)defaultName;
- (NSDictionary *)dictionaryForKey:(NSString *)defaultName;
- (NSData *)dataForKey:(NSString *)defaultName;

- (BOOL)synchronize;

@end
